# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 8
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR8_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR8(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    
    if always_d:
        return "D"
    
    current_round = len(my_history) + 1
    
    if current_round >= 9:
        return "D"
    
    if always_c:
        if current_round % 3 == 0:
            return "D"
        else:
            return "C"
    
    if len(opp_history) > 0 and opp_history[-1] == "D":
        if any(move == "D" for move in my_history[:len(opp_history)-1]):
            return "D"
        else:
            if random.random() < 0.1:
                return "C"
            else:
                return "D"
    
    if len(opp_history) >= 1 and any(move == "D" for move in opp_history) and not any(move == "D" for move in my_history[:len(opp_history)]):
        return "D"
    
    return "C"